<?php
header('Content-Type: application/json; charset=utf-8');

$host = "localhost";
$user = "sohag66_sohag";
$pass = "sohagahammed@66";
$db   = "sohag66_rasturant_managment";


$conn = mysqli_connect($host, $user, $pass, $db);

mysqli_set_charset($conn, "utf8mb4");

if (!$conn) {
    echo json_encode(['status' => false, 'message' => 'Database connection failed: ' . mysqli_connect_error()], JSON_UNESCAPED_UNICODE);
    exit;
}

$sql = "SELECT * FROM products ORDER BY id DESC";
$result = mysqli_query($conn, $sql);

if (!$result) {
    echo json_encode(['status' => false, 'message' => 'Query failed: ' . mysqli_error($conn)], JSON_UNESCAPED_UNICODE);
    mysqli_close($conn);
    exit;
}

if (mysqli_num_rows($result) === 0) {
    echo json_encode(['status' => false, 'message' => 'No products found'], JSON_UNESCAPED_UNICODE);
    mysqli_close($conn);
    exit;
}


$products = [];

while ($row = mysqli_fetch_assoc($result)) {
    $product_id = (int)$row['id'];

    $ingredient_query = mysqli_prepare($conn, "SELECT name, unit, quantity FROM product_ingredients WHERE product_id = ?");
    mysqli_stmt_bind_param($ingredient_query, "i", $product_id);
    mysqli_stmt_execute($ingredient_query);
    $ingredient_result = mysqli_stmt_get_result($ingredient_query);

    $ingredients = [];
    while ($ing = mysqli_fetch_assoc($ingredient_result)) {
        $ingredients[] = $ing;
    }

    mysqli_stmt_close($ingredient_query);

    $imageFile = $row['image_url'];
    $row['image_url'] = 'https://sohagdeveloper.xyz/Rasturant_management/uploads/' . $imageFile;

    $row['ingredients'] = $ingredients;

    $products[] = $row;
}


echo json_encode(['status' => true, 'products' => $products], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

mysqli_close($conn);
?>
