<?php
header('Content-Type: application/json; charset=utf-8');

$name = $_POST['name'] ?? '';
$details = $_POST['details'] ?? '';
$regular_price = $_POST['regular_price'] ?? 0;
$discount = $_POST['discount'] ?? 0;
$imageBase64 = $_POST['image'] ?? '';
$ingredientsJson = $_POST['ingredients'] ?? '[]';

if(empty($name) || empty($details) || empty($imageBase64) || empty($ingredientsJson)){
    echo json_encode(['status'=>false, 'message'=>'Missing required fields']);
    exit;
}

$imageData = base64_decode($imageBase64);
$imageName = 'product_'.time().'.jpg';
file_put_contents('uploads/'.$imageName, $imageData);

$ingredients = json_decode($ingredientsJson, true); 

$host = "localhost";
$user = "sohag66_sohag";
$pass = "sohagahammed@66";
$db   = "sohag66_rasturant_managment";

$conn = mysqli_connect($host, $user, $pass, $db);
if(!$conn){
    die(json_encode(['status'=>false, 'message'=>'DB connection failed: '.mysqli_connect_error()]));
}
mysqli_set_charset($conn, "utf8mb4");

$stmt = $conn->prepare("INSERT INTO products (name, details, regular_price, discount, image_url) VALUES (?, ?, ?, ?, ?)");
$stmt->bind_param("ssdds", $name, $details, $regular_price, $discount, $imageName);
$stmt->execute();
$product_id = $stmt->insert_id;
$stmt->close();



foreach($ingredients as $ingredient){
    $ing_name = $ingredient['name'];
    $unit = $ingredient['unit'];
    $quantity = $ingredient['quantity'];

    $stmt2 = $conn->prepare("INSERT INTO product_ingredients (product_id, name, unit, quantity) VALUES (?, ?, ?, ?)");
    $stmt2->bind_param("issd", $product_id, $ing_name, $unit, $quantity);
    $stmt2->execute();
    $stmt2->close();
}

$conn->close();

echo json_encode(['status'=>true, 'message'=>'Product added successfully']);
?>
