<?php
header('Content-Type: application/json; charset=utf-8');

$Ingredient = $_POST['Ingredient'] ?? '';
$unite = $_POST['unite'] ?? '';
$Stock = $_POST['Stock'] ?? '';
$MinLavel = $_POST['MinLavel'] ?? '';

if (empty($Ingredient) || empty($unite)) {
    echo json_encode(["status" => false, "message" => "Missing required fields"]);
    exit;
}

$host = "localhost";
$user = "sohag66_sohag";
$pass = "sohagahammed@66";
$db   = "sohag66_rasturant_managment";

$conn = mysqli_connect($host, $user, $pass, $db);
if(!$conn){
    die(json_encode(['status'=>false, 'message'=>'DB connection failed: '.mysqli_connect_error()]));
}
mysqli_set_charset($conn, "utf8mb4");

// 1️⃣ Check if ingredient exists
$checkSql = "SELECT id, Stock, MinLavel FROM Ingredients WHERE Ingredient = ?";
$stmt = $conn->prepare($checkSql);
$stmt->bind_param("s", $Ingredient);
$stmt->execute();
$result = $stmt->get_result();

if($result->num_rows > 0){
    // Ingredient exists → update
    $row = $result->fetch_assoc();
    $existingId = $row['id'];
    $existingStock = $row['Stock'];
    $existingMin = $row['MinLavel'];

    // Example: add new stock to existing stock
    $newStock = $existingStock + $Stock;
    // For MinLevel, take max (or whatever logic you prefer)
   $newMin = $MinLavel;

    $updateSql = "UPDATE Ingredients SET Stock = ?, MinLavel = ?, unite = ? WHERE id = ?";
    $updateStmt = $conn->prepare($updateSql);
    $updateStmt->bind_param("ddsi", $newStock, $newMin, $unite, $existingId);
    if($updateStmt->execute()){
        echo json_encode(["status" => true, "message" => "Ingredient updated successfully"]);
    } else {
        echo json_encode(["status" => false, "message" => "Database update failed"]);
    }
    $updateStmt->close();

} else {
    // Ingredient does not exist → insert new
    $insertSql = "INSERT INTO Ingredients (Ingredient, unite, Stock, MinLavel) VALUES (?, ?, ?, ?)";
    $insertStmt = $conn->prepare($insertSql);
    $insertStmt->bind_param("ssdd", $Ingredient, $unite, $Stock, $MinLavel);
    if($insertStmt->execute()){
        echo json_encode(["status" => true, "message" => "Ingredient added successfully"]);
    } else {
        echo json_encode(["status" => false, "message" => "Database insert failed"]);
    }
    $insertStmt->close();
}

$stmt->close();
$conn->close();
?>
